<?php

// Begin output to file
header('Pragma: anytextexeptno-cache', true);
header("Content-type: application/csv");

header("Content-Disposition: attachment; filename=REDCapDataDictonaryDemo.csv");

?>
Variable / Field Name,Form Name,Section Header,Field Type,Field Label,"Choices, Calculations, OR Slider Labels",Field Note,Text Validation Type OR Show Slider Number,Text Validation Min,Text Validation Max,Identifier?,Branching Logic (Show field only if...),Required Field?,Custom Alignment,Question Number (surveys only),Matrix Group Name
study_id,demographics,,text,Study ID,,,,,,,,,,,
date_enrolled,demographics,Demographic Characteristics,text,Date subject signed consent,,YYYY-MM-DD,date,,,,,,,,
first_name,demographics,,text,First Name,,,,,,y,,,,,
last_name,demographics,,text,Last Name,,,,,,y,,,,,
address,demographics,Contact Information,notes,"Street, City, State, ZIP",,,,,,y,,,,,
telephone_1,demographics,,text,Phone number,,Include Area Code,phone,,,y,,,,,
telephone_2,demographics,,text,Second phone number,,Include Area Code,phone,,,y,,,,,
email,demographics,,text,E-mail,,,email,,,y,,,,,
sex,demographics,,dropdown,Sex,"0, Female | 1, Male",,,,,,,y,,,
given_birth,demographics,,dropdown,Has the subject given birth before?,"0, No | 1, Yes",,,,,,"[sex] = ""0""",,,,
num_children,demographics,,text,How many times has the subject given birth?,,,integer,0,,,"[sex] = ""0"" and [given_birth] = ""1""",,,,
ethnicity,demographics,,radio,Ethnicity,"0, Hispanic or Latino | 1, NOT Hispanic or Latino | 2, Unknown / Not Reported",,,,,,,,,,
race,demographics,,checkbox,Race,"0, American Indian/Alaska Native | 1, Asian | 2, Native Hawaiian or Other Pacific Islander | 3, Black or African American | 4, White | 5, More Than One Race | 6, Unknown / Not Reported",,,,,,,,,,
dob,demographics,,text,Date of birth,,,date,,,y,,,,,
age,demographics,,calc,Age (years),"round(datediff([dob],'today','y'),0)",,,,,,,,,,
height,demographics,,text,Height (cm),,,number,130,215,,,,,,
weight,demographics,,text,Weight (kilograms),,,integer,35,200,,,,,,
bmi,demographics,,calc,BMI,"round(([weight]*10000)/(([height])^(2)),1)",,,,,,,,,,
patient_document,demographics,,file,Patient document,,,,,,,,,,,
comorbidities,demographics,,text,Any comorbid condition,,,,,,,,,,,
diabetes,demographics,,dropdown,Patient has a diagnosis of diabetes mellitus?,"0, No | 1, Yes",,,,,,,,,,
diabetes_type,demographics,,dropdown,Type of Diabetes Mellitus,"0, Type 1 insulin-dependent | 1, Type 2 insulin-dependent | 2, Type 2 non insulin-dependent",,,,,,,,,,
gym,demographics,Please provide the patient's weekly schedule for the activities below.,checkbox,Gym (Weight Training),"0, Monday | 1, Tuesday | 2, Wednesday | 3, Thursday | 4, Friday",,,,,,,,,,weekly_schedule
aerobics,demographics,,checkbox,Aerobics,"0, Monday | 1, Tuesday | 2, Wednesday | 3, Thursday | 4, Friday",,,,,,,,,,weekly_schedule
eat,demographics,,checkbox,Eat Out (Dinner/Lunch),"0, Monday | 1, Tuesday | 2, Wednesday | 3, Thursday | 4, Friday",,,,,,,,,,weekly_schedule
drink,demographics,,checkbox,Drink (Alcoholic Beverages),"0, Monday | 1, Tuesday | 2, Wednesday | 3, Thursday | 4, Friday",,,,,,,,,,weekly_schedule
dialysis_initiation,demographics,Dialysis Information,text,Date of first outpatient dialysis treatment,,,date,,,,,,,,
access_type,demographics,,dropdown,Type of vascular access,"0, Graft | 1, Fistula | 2, Catheter with maturing graft | 3, Catheter with maturing fistula",,,,,,,,,,
access_location,demographics,,dropdown,Location of currently used vascular access,"0, Forearm | 1, Upper arm | 2, Internal jugular vein | 3, Subclavian vein | 4, Other",,,,,,,,,,
dialysis_unit_name,demographics,,text,Name of dialysis unit,,,,,,,,,,,
dialysis_unit_phone,demographics,,text,Phone number,,Include Area Code,phone,,,,,,,,
dialysis_schedule_days,demographics,,radio,Days of the week patient is dialyzed,"0, Monday-Wednesday-Friday | 1, Tuesday-Thursday-Saturday | 2, Other",,,,,,,,,,
dialysis_schedule_time,demographics,,dropdown,Shift patient is dialyzed,"0, First shift | 1, Second shift | 2, Third shift | 3, Fourth shift",,,,,,,,,,
etiology_esrd,demographics,,dropdown,Etiology of ESRD,"0, Diabetes | 1, Hypertension | 2, Glomerulonephritis | 3, Polycystic Kidney Disease | 4, Interstitial Nephritis | 5, Hereditary Nephritis | 6, Other",,,,,,,,,,
subject_comments,demographics,General Comments,notes,Comments,,,,,,,,,,,
date_visit_b,baseline_data,Baseline Measurements,text,Date of baseline visit,,,date,,,,,,,,
date_blood_b,baseline_data,,text,Date blood was drawn,,,date,,,,,,,,
alb_b,baseline_data,,text,Serum Albumin (g/dL),,,integer,3,5,,,,,,
prealb_b,baseline_data,,text,Serum Prealbumin (mg/dL),,,number,10,40,,,,,,
creat_b,baseline_data,,text,Creatinine (mg/dL),,,number,0.5,20,,,,,,
npcr_b,baseline_data,,text,Normalized Protein Catabolic Rate (g/kg/d),,,number,0.5,2,,,,,,
chol_b,baseline_data,,text,Cholesterol (mg/dL),,,number,100,300,,,,,,
transferrin_b,baseline_data,,text,Transferrin (mg/dL),,,number,100,300,,,,,,
kt_v_b,baseline_data,,text,Kt/V,,,number,0.9,3,,,,,,
drywt_b,baseline_data,,text,Dry weight (kilograms),,,number,35,200,,,,,,
plasma1_b,baseline_data,,dropdown,Collected Plasma 1?,"0, No | 1, Yes",,,,,,,,,,
plasma2_b,baseline_data,,dropdown,Collected Plasma 2?,"0, No | 1, Yes",,,,,,,,,,
plasma3_b,baseline_data,,dropdown,Collected Plasma 3?,"0, No | 1, Yes",,,,,,,,,,
serum1_b,baseline_data,,dropdown,Collected Serum 1?,"0, No | 1, Yes",,,,,,,,,,
serum2_b,baseline_data,,dropdown,Collected Serum 2?,"0, No | 1, Yes",,,,,,,,,,
serum3_b,baseline_data,,dropdown,Collected Serum 3?,"0, No | 1, Yes",,,,,,,,,,
sga_b,baseline_data,,text,Subject Global Assessment (score = 1-7),,,number,0.9,7.1,,,,,,
date_supplement_dispensed,baseline_data,,text,Date patient begins supplement,,,date,,,,,,,,
date_visit_1,month_1_data,Month 1,text,Date of Month 1 visit,,,date,,,,,,,,
alb_1,month_1_data,,text,Serum Albumin (g/dL),,,number,3,5,,,,,,
prealb_1,month_1_data,,text,Serum Prealbumin (mg/dL),,,number,10,40,,,,,,
creat_1,month_1_data,,text,Creatinine (mg/dL),,,number,0.5,20,,,,,,
npcr_1,month_1_data,,text,Normalized Protein Catabolic Rate (g/kg/d),,,number,0.5,2,,,,,,
chol_1,month_1_data,,text,Cholesterol (mg/dL),,,number,100,300,,,,,,
transferrin_1,month_1_data,,text,Transferrin (mg/dL),,,number,100,300,,,,,,
kt_v_1,month_1_data,,text,Kt/V,,,number,0.9,3,,,,,,
drywt_1,month_1_data,,text,Dry weight (kilograms),,,number,35,200,,,,,,
no_show_1,month_1_data,,text,Number of treatments missed,,,number,0,7,,,,,,
compliance_1,month_1_data,,dropdown,How compliant was the patient in drinking the supplement?,"0, 100 percent | 1, 99-75 percent | 2, 74-50 percent | 3, 49-25 percent | 4, 0-24 percent",,,,,,,,,,
hospit_1,month_1_data,Hospitalization Data,dropdown,Was patient hospitalized since last visit?,"0, No | 1, Yes",,,,,,,,,,
cause_hosp_1,month_1_data,,dropdown,What was the cause of hospitalization?,"1, Vascular access related events | 2, CVD events | 3, Other",,,,,,,,,,
admission_date_1,month_1_data,,text,Date of hospital admission,,,date,,,,,,,,
discharge_date_1,month_1_data,,text,Date of hospital discharge,,,date,,,,,,,,
discharge_summary_1,month_1_data,,dropdown,Discharge summary in patients binder?,"0, No | 1, Yes",,,,,,,,,,
death_1,month_1_data,Mortality Data,dropdown,Has patient died since last visit?,"0, No | 1, Yes",,,,,,,,,,
date_death_1,month_1_data,,text,Date of death,,,date,,,,,,,,
cause_death_1,month_1_data,,dropdown,What was the cause of death?,"1, All-cause | 2, Cardiovascular",,,,,,,,,,
date_visit_2,month_2_data,Month 2,text,Date of Month 2 visit,,,date,,,,,,,,
alb_2,month_2_data,,text,Serum Albumin (g/dL),,,number,3,5,,,,,,
prealb_2,month_2_data,,text,Serum Prealbumin (mg/dL),,,number,10,40,,,,,,
creat_2,month_2_data,,text,Creatinine (mg/dL),,,number,0.5,20,,,,,,
npcr_2,month_2_data,,text,Normalized Protein Catabolic Rate (g/kg/d),,,number,0.5,2,,,,,,
chol_2,month_2_data,,text,Cholesterol (mg/dL),,,number,100,300,,,,,,
transferrin_2,month_2_data,,text,Transferrin (mg/dL),,,number,100,300,,,,,,
kt_v_2,month_2_data,,text,Kt/V,,,number,0.9,3,,,,,,
drywt_2,month_2_data,,text,Dry weight (kilograms),,,number,35,200,,,,,,
no_show_2,month_2_data,,text,Number of treatments missed,,,number,0,7,,,,,,
compliance_2,month_2_data,,dropdown,How compliant was the patient in drinking the supplement?,"0, 100 percent | 1, 99-75 percent | 2, 74-50 percent | 3, 49-25 percent | 4, 0-24 percent",,,,,,,,,,
hospit_2,month_2_data,Hospitalization Data,dropdown,Was patient hospitalized since last visit?,"0, No | 1, Yes",,,,,,,,,,
cause_hosp_2,month_2_data,,dropdown,What was the cause of hospitalization?,"1, Vascular access related events | 2, CVD events | 3, Other",,,,,,,,,,
admission_date_2,month_2_data,,text,Date of hospital admission,,,date,,,,,,,,
discharge_date_2,month_2_data,,text,Date of hospital discharge,,,date,,,,,,,,
discharge_summary_2,month_2_data,,dropdown,Discharge summary in patients binder?,"0, No | 1, Yes",,,,,,,,,,
death_2,month_2_data,Mortality Data,dropdown,Has patient died since last visit?,"0, No | 1, Yes",,,,,,,,,,
date_death_2,month_2_data,,text,Date of death,,,date,,,,,,,,
cause_death_2,month_2_data,,dropdown,What was the cause of death?,"1, All-cause | 2, Cardiovascular",,,,,,,,,,
date_visit_3,month_3_data,Month 3,text,Date of Month 3 visit,,,date,,,,,,,,
date_blood_3,month_3_data,,text,Date blood was drawn,,,date,,,,,,,,
alb_3,month_3_data,,text,Serum Albumin (g/dL),,,number,3,5,,,,,,
prealb_3,month_3_data,,text,Serum Prealbumin (mg/dL),,,number,10,40,,,,,,
creat_3,month_3_data,,text,Creatinine (mg/dL),,,number,0.5,20,,,,,,
npcr_3,month_3_data,,text,Normalized Protein Catabolic Rate (g/kg/d),,,number,0.5,2,,,,,,
chol_3,month_3_data,,text,Cholesterol (mg/dL),,,number,100,300,,,,,,
transferrin_3,month_3_data,,text,Transferrin (mg/dL),,,number,100,300,,,,,,
kt_v_3,month_3_data,,text,Kt/V,,,number,0.9,3,,,,,,
drywt_3,month_3_data,,text,Dry weight (kilograms),,,number,35,200,,,,,,
plasma1_3,month_3_data,,dropdown,Collected Plasma 1?,"0, No | 1, Yes",,,,,,,,,,
plasma2_3,month_3_data,,dropdown,Collected Plasma 2?,"0, No | 1, Yes",,,,,,,,,,
plasma3_3,month_3_data,,dropdown,Collected Plasma 3?,"0, No | 1, Yes",,,,,,,,,,
serum1_3,month_3_data,,dropdown,Collected Serum 1?,"0, No | 1, Yes",,,,,,,,,,
serum2_3,month_3_data,,dropdown,Collected Serum 2?,"0, No | 1, Yes",,,,,,,,,,
serum3_3,month_3_data,,dropdown,Collected Serum 3?,"0, No | 1, Yes",,,,,,,,,,
sga_3,month_3_data,,text,Subject Global Assessment (score = 1-7),,,number,0.9,7.1,,,,,,
no_show_3,month_3_data,,text,Number of treatments missed,,,number,0,7,,,,,,
compliance_3,month_3_data,,dropdown,How compliant was the patient in drinking the supplement?,"0, 100 percent | 1, 99-75 percent | 2, 74-50 percent | 3, 49-25 percent | 4, 0-24 percent",,,,,,,,,,
hospit_3,month_3_data,Hospitalization Data,dropdown,Was patient hospitalized since last visit?,"0, No | 1, Yes",,,,,,,,,,
cause_hosp_3,month_3_data,,dropdown,What was the cause of hospitalization?,"1, Vascular access related events | 2, CVD events | 3, Other",,,,,,,,,,
admission_date_3,month_3_data,,text,Date of hospital admission,,,date,,,,,,,,
discharge_date_3,month_3_data,,text,Date of hospital discharge,,,date,,,,,,,,
discharge_summary_3,month_3_data,,dropdown,Discharge summary in patients binder?,"0, No | 1, Yes",,,,,,,,,,
death_3,month_3_data,Mortality Data,dropdown,Has patient died since last visit?,"0, No | 1, Yes",,,,,,,,,,
date_death_3,month_3_data,,text,Date of death,,,date,,,,,,,,
cause_death_3,month_3_data,,dropdown,What was the cause of death?,"1, All-cause | 2, Cardiovascular",,,,,,,,,,
complete_study,completion_data,Study Completion Information,dropdown,Has patient completed study?,"0, No | 1, Yes",,,,,,,,,,
withdraw_date,completion_data,,text,Put a date if patient withdrew study,,,date,,,,,,,,
withdraw_reason,completion_data,,dropdown,Reason patient withdrew from study,"0, Non-compliance | 1, Did not wish to continue in study | 2, Could not tolerate the supplement | 3, Hospitalization | 4, Other",,,,,,,,,,
complete_study_date,completion_data,,text,Date of study completion,,,date,,,,,,,,
study_comments,completion_data,General Comments,notes,Comments,,,,,,,,,,,